' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com. 
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Partial Class Categories
  Inherits System.Web.UI.Page

  Protected Sub btnNew_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnNew.Click
    ShowNewPanel()
  End Sub

  Protected Sub fvNewCategory_ItemInserted(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.FormViewInsertedEventArgs) Handles fvNewCategory.ItemInserted
    ShowListPanel()
  End Sub

  Protected Sub btnCancel_Click(ByVal sender As Object, ByVal e As System.EventArgs)
    ShowListPanel()
  End Sub

  Protected Sub sdsCategories_AfterInsertOrUpdate(ByVal sender As Object, _
      ByVal e As System.Web.UI.WebControls.SqlDataSourceStatusEventArgs) _
      Handles sdsCategories.Inserted, sdsCategories.Updated

    ' Pozyskaj warto zwracan przez procedur skadowan. Cokolwiek wikszego ni 0 to nowy identyfikator rekordu
    ' -1 oznacza, e pozycja ju istnieje
    Dim id As Integer = Convert.ToInt32(e.Command.Parameters("@returnValue").Value)
    If id = -1 Then
      lblErrorMessage.Text = "Istnieje kategoria o podanym opisie." & _
           "Zmiany nie zostay zapisane.<br />"
      lblErrorMessage.Visible = True
    End If
  End Sub

  Private Sub ShowNewPanel()
    pnlNew.Visible = True
    pnlList.Visible = False
  End Sub

  Private Sub ShowListPanel()
    pnlNew.Visible = False
    pnlList.Visible = True
  End Sub
End Class
